<?php
// Fetch required classes
require_once(DIR . '/dbtech/downloads/includes/class_core.php');
require_once(DIR . '/dbtech/downloads/includes/class_cache.php');
if (intval($vbulletin->versionnumber) == 3 AND !class_exists('vB_Template'))
{
	// We need the template class
	require_once(DIR . '/dbtech/downloads/includes/class_template.php');
}	

if (isset($this) AND is_object($this))
{
	// Loads the cache class
	VBDOWNLOADS_CACHE::init($vbulletin, $this->datastore_entries, array('dbtech_downloads_usergroup'));
}
else
{
	// Loads the cache class
	VBDOWNLOADS_CACHE::init($vbulletin, $specialtemplates, array('dbtech_downloads_usergroup'));
}

// Initialise forumon
VBDOWNLOADS::init($vbulletin);

if (VBDOWNLOADS::$permissions['canview'])
{
	$show['downloads'] = true;
	$show['downloads_ispro'] = VBDOWNLOADS::$isPro;
	$show['downloads_canfavourites'] = $vbulletin->options['dbtech_downloads_favourites'];
	$show['downloads_canmodcp'] = VBDOWNLOADS::$permissions['ismanager'];
	/*DBTECH_PRO_START*/
	$show['downloads_cancategory'] = (VBDOWNLOADS::$permissions['cancreatecategory'] OR VBDOWNLOADS::$permissions['ismanager']);
	$show['downloads_canimport'] = (VBDOWNLOADS::$permissions['canimportfiles'] OR VBDOWNLOADS::$permissions['ismanager']);
	/*DBTECH_PRO_END*/
	if ($vbulletin->options['dbtech_downloads_integration'] & 1)
	{
		$show['downloads_ql'] = true;
	}
	if ($vbulletin->options['dbtech_downloads_integration'] & 2)
	{
		$show['downloads_com'] = true;
	}
}

// Show branding or not
$show['downloads_branding'] = $vbulletin->options['dbtech_downloads_branding_free'] != base64_decode('dmJzdXBwb3J0Lm9yZw==');
$show['dbtech_downloads_producttype'] = (VBDOWNLOADS::$isPro ? ' (Pro)' : ' (Lite)');

if (THIS_SCRIPT == 'downloads' AND $show['downloads_branding'] AND !$show['_dbtech_branding_override'])
{
	$brandingVariables = array(
		'flavour' 			=> 'Downloads Management provided by ',
		'productid' 		=> 78,
		'utm_source' 		=> str_replace('www.', '', $_SERVER['HTTP_HOST']),		
		'utm_content' 		=> (VBDOWNLOADS::$isPro ? 'Pro' : 'Lite'),
		'referrerid' 		=> $vbulletin->options['dbtech_downloads_referral'],
		'title' 			=> 'vBDownloads',
		'displayversion' 	=> $vbulletin->options['dbtech_downloads_displayversion'],
		'version' 			=> VBDOWNLOADS::$version,
		'producttype' 		=> $show['dbtech_downloads_producttype'],
		'showhivel' 		=> (!VBDOWNLOADS::$isPro AND !$vbulletin->options['dbtech_downloads_nohivel'])
	);

	$str = $brandingVariables['flavour'] . '
		<a rel="nofollow" href="http://www.dragonbyte-tech.com/vbecommerce.php' . ($brandingVariables['productid'] ? '?productid=' . $brandingVariables['productid'] . '&do=product&' : '?') . 'utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=Footer%2BLinks&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">' . $brandingVariables['title'] . ($brandingVariables['displayversion'] ? ' v' . $brandingVariables['version'] : '') . $brandingVariables['producttype'] . '</a> - 
		<a href="http://www.dragonbyte-tech.com/?utm_source=' . $brandingVariables['utm_source'] . '&utm_campaign=Footer%2BLinks&utm_medium=' . urlencode(str_replace(' ', '+', $brandingVariables['title'])) . '&utm_content=' . $brandingVariables['utm_content'] . ($brandingVariables['referrerid'] ? '&referrerid=' . $brandingVariables['referrerid'] : '') . '" target="_blank">vBulletin Mods &amp; Addons</a> Copyright &copy; ' . date('Y') . ' DragonByte Technologies Ltd.' . 
		($brandingVariables['showhivel'] ? ' Runs best on <a href="http://www.hivelocity.net/?utm_source=Iain%2BKidd&utm_medium=back%2Blink&utm_term=Dedicated%2BServer%2BSponsor&utm_campaign=Back%2BLinks%2Bfrom%2BIain%2BKidd" target="_blank">HiVelocity Hosting</a>.' : '');
	$vbulletin->options['copyrighttext'] = (trim($vbulletin->options['copyrighttext']) != '' ? $str . '<br />' . $vbulletin->options['copyrighttext'] : $str);
}